<?php
/**
 * Module Name: BuddyStream Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'buddystream_init' ) ) :

 //*************** Actions ***************\\
 add_action("buddystream_facebook_activated", "wpachievements_buddystream_facebook_activated", 10);
 add_action("buddystream_flickr_activated", "wpachievements_buddystream_flickr_activated", 10);
 add_action("buddystream_lastfm_activated", "wpachievements_buddystream_lastfm_activated", 10);
 add_action("buddystream_twitter_activated", "wpachievements_buddystream_twitter_activated", 10);
 add_action("buddystream_youtube_activated", "wpachievements_buddystream_youtube_activated", 10);
 //*************** Detect Buddysteam Facebook Activation ***************\\
 function wpachievements_buddystream_facebook_activated(){
   if( is_user_logged_in() ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'buddystream_facebook_activated',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => 0,
    ) );
   }
 }
 //*************** Detect Buddysteam Flickr Activation ***************\\
 function wpachievements_buddystream_flickr_activated(){
   if( is_user_logged_in() ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'buddystream_flickr_activated',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => 0,
    ) );     
   }
 }
 //*************** Detect Buddysteam Lastfm Activation ***************\\
 function wpachievements_buddystream_lastfm_activated(){
   if( is_user_logged_in() ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'buddystream_lastfm_activated',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => 0,
    ) );       
   }
 }
 //*************** Detect Buddysteam Twitter Activation ***************\\
 function wpachievements_buddystream_twitter_activated(){
   if( is_user_logged_in() ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'buddystream_twitter_activated',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => 0,
    ) );        
   }
 }
 //*************** Detect Buddysteam Youtube Activation ***************\\
 function wpachievements_buddystream_youtube_activated(){
   if( is_user_logged_in() ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'buddystream_youtube_activated',
      'user_id'     => '',
      'post_id'     => '',
      'points'      => 0,
    ) );      
   }
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_buddystream_desc', 10, 2);
 function achievement_buddystream_desc($text='',$type=''){
 switch($type){
   case 'buddystream_facebook_activated': { $text = __('for connecting your Flickr account', 'wpachievements'); } break;
   case 'buddystream_flickr_activated': { $text = __('for connecting your Last.fm account', 'wpachievements'); } break;
   case 'buddystream_lastfm_activated': { $text = __('for connecting your Twitter account', 'wpachievements'); } break;
   case 'buddystream_twitter_activated': { $text = __('for connecting your Flickr account', 'wpachievements'); } break;
   case 'buddystream_youtube_activated': { $text = __('for connecting your YouTube account', 'wpachievements'); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_buddystream_desc', 10, 2);
 function quest_buddystream_desc($text='',$type=''){
 switch($type){
   case 'buddystream_facebook_activated': { $text = __('Connect your Flickr account', 'wpachievements'); } break;
   case 'buddystream_flickr_activated': { $text = __('Connect your Last.fm account', 'wpachievements'); } break;
   case 'buddystream_lastfm_activated': { $text = __('Connect your Twitter account', 'wpachievements'); } break;
   case 'buddystream_twitter_activated': { $text = __('Connect your Flickr account', 'wpachievements'); } break;
   case 'buddystream_youtube_activated': { $text = __('Connect your YouTube account', 'wpachievements'); } break;
  }
  return $text;
 }

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_buddystream_admin_events', 10);
 function achievement_buddystream_admin_events(){
   echo'<optgroup label="BuddyStream Events">
     <option value="buddystream_facebook_activated">'.__('The user connects their Facebook account to BuddyStream', 'wpachievements').'</option>
     <option value="buddystream_flickr_activated">'.__('The user connects their Flickr account to BuddyStream', 'wpachievements').'</option>
     <option value="buddystream_lastfm_activated">'.__('The user connects their Last.fm account to BuddyStream', 'wpachievements').'</option>
     <option value="buddystream_twitter_activated">'.__('The user connects their Twitter account to BuddyStream', 'wpachievements').'</option>
     <option value="buddystream_youtube_activated">'.__('The user connects their YouTube account to BuddyStream', 'wpachievements').'</option>
   </optgroup>';
 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_buddystream_admin_triggers', 1, 10);
 function achievement_buddystream_admin_triggers($trigger){

   switch($trigger){
     case 'buddystream_facebook_activated': { $trigger = __('The user connects their Facebook account to BuddyStream', 'wpachievements'); } break;
     case 'buddystream_flickr_activated': { $trigger = __('The user connects their Flickr account to BuddyStream', 'wpachievements'); } break;
     case 'buddystream_lastfm_activated': { $trigger = __('The user connects their Last.fm account to BuddyStream', 'wpachievements'); } break;
     case 'buddystream_twitter_activated': { $trigger = __('The user connects their Twitter account to BuddyStream', 'wpachievements'); } break;
     case 'buddystream_youtube_activated': { $trigger = __('The user connects their YouTube account to BuddyStream', 'wpachievements'); } break;
   }

   return $trigger;
 }
endif;
?>